/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.enumeration.UserProfileActivationAction;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class UserProfileActivationStateUtils {

    /**
     * 
     */
    private UserProfileActivationStateUtils() {
    }
    
    public static final UserProfileActivationAction ACTIVATED = 
        UserProfileActivationAction.getEnum(UserProfileActivationAction.
        ACTIVATED);
    
    public static final UserProfileActivationAction DEACTIVATED = 
        UserProfileActivationAction.getEnum(UserProfileActivationAction.
        DEACTIVATED);

    public static boolean isActivated(UserProfileActivationAction action) {
        Precondition.assertNotNull("action", action);
        return ACTIVATED.equals(action);
    }

    public static boolean isActivated(String action) {
        Precondition.assertNotNull("action", action);
        return ACTIVATED.getName().equals(action);
    }

    public static boolean isDeactivated(UserProfileActivationAction action) {
        Precondition.assertNotNull("action", action);
        return DEACTIVATED.equals(action);
    }
    
    public static boolean isDeactivated(String action) {
        Precondition.assertNotNull("action", action);
        return DEACTIVATED.getName().equals(action);
    }

}
